<?php
// Include the database connection file
require_once 'db.php';

// Set the response header to JSON
header('Content-Type: application/json');

try {
    // Fetch data from the shippingmethod table with conditions
    $query = "
        SELECT 
            sm.shippingid,
            sm.free_shipping_amount,
            sm.rate AS srate,
            sm.mode,
            sm.delete_status,
            sr.rangeid,
            sr.latitude,
            sr.longitude,
            sr.radius,
            sw.weight_id,
            sw.weight,
            sw.unit,
            sw.rate,
            ss.slot_id,
            ss.name,
            ss.start_time,
            ss.end_time,
            st.shippingtime_id,
            st.start_time,
            st.end_time,
            st.delivery_done,
            st.delivery_done_time
        FROM 
            shippingmethod sm
        LEFT JOIN 
            shipping_range sr ON sm.shippingid = sr.shipping_id
        LEFT JOIN 
            shipping_weight sw ON sm.shippingid = sw.shipping_id
        LEFT JOIN 
            shipping_slot ss ON sm.shippingid = ss.shipping_id
        LEFT JOIN 
            shipping_time st ON sm.shippingid = st.shipping_id
        WHERE 
            sm.mode = 1 AND sm.delete_status = 0
    ";

    // Execute the query directly
    $result = $conn->query($query);

    if (!$result) {
        throw new Exception("Query failed: " . $conn->error);
    }

    // Fetch all results as an associative array
    $results = [];
    while ($row = $result->fetch_assoc()) {
        $results[] = $row;
    }

    // Organize the data into a structured format
    $shippingMethods = [];
    foreach ($results as $row) {
        $shippingId = $row['shippingid'];

        // Initialize the shipping method entry if it doesn't exist
        if (!isset($shippingMethods[$shippingId])) {
            $shippingMethods[$shippingId] = [
                'shipping_id' => $row['shippingid'],
                'free_shipping_amount' => $row['free_shipping_amount'],
                'srate' => $row['srate'],
                'mode' => $row['mode'],
                'delete_status' => $row['delete_status'],
                'ranges' => [],
                'weights' => [],
                'slots' => [],
                'times' => []
            ];
        }

        // Add range data if it exists
        if ($row['rangeid'] && !in_array($row['rangeid'], array_column($shippingMethods[$shippingId]['ranges'], 'rangeid'))) {
            $shippingMethods[$shippingId]['ranges'][] = [
                'range_id' => $row['rangeid'],
                'latitude' => $row['latitude'],
                'longitude' => $row['longitude'],
                'radius' => $row['radius']
            ];
        }

        // Add weight data if it exists
        if ($row['weight_id'] && !in_array($row['weight_id'], array_column($shippingMethods[$shippingId]['weights'], 'weight_id'))) {
            $shippingMethods[$shippingId]['weights'][] = [
                'weight_id' => $row['weight_id'],
                'weight' => $row['weight'],
                'unit' => $row['unit'],
                'rate' => $row['rate']
            ];
        }

        // Add slot data if it exists
        if ($row['slot_id'] && !in_array($row['slot_id'], array_column($shippingMethods[$shippingId]['slots'], 'slot_id'))) {
            $shippingMethods[$shippingId]['slots'][] = [
                'slot_id' => $row['slot_id'],
                'name' => $row['name'],
                'start_time' => $row['start_time'],
                'end_time' => $row['end_time']
            ];
        }

        // Add time data if it exists
        if ($row['shippingtime_id'] && !in_array($row['shippingtime_id'], array_column($shippingMethods[$shippingId]['times'], 'shippingtime_id'))) {
            $shippingMethods[$shippingId]['times'][] = [
                'shippingtime_id' => $row['shippingtime_id'],
                'start_time' => $row['start_time'],
                'end_time' => $row['end_time'],
                'delivery_done' => $row['delivery_done'],
                'delivery_done_time' => $row['delivery_done_time']
            ];
        }
    }

    // Convert the associative array to a simple array
    $shippingMethods = array_values($shippingMethods);

    // Return the response as JSON
    echo json_encode([
        'status' => 'success',
        'data' => $shippingMethods
    ]);
} catch (Exception $e) {
    // Handle errors
    echo json_encode([
        'status' => 'error',
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
?>